﻿////////////// jZugAnimate.js ////////////// 
// This script requires jquery
//
// Created by: Antonio Zugno
//
////////////////////////////////////////////

function jAnimateDiv(divNameArray, transitionDelay, animationDelay, currentSlideNumber) {
    
    var slideCount = divNameArray.length;
    
    // Checking if first run - currentSlideNumber should be null
    if (typeof (currentSlideNumber) == 'undefined') {
        // Setting css for parent div
        $("#" + divNameArray[0]).parent().css({ position: "relative" });

        // Displaying first frame
        $("#" + divNameArray[0]).css({ opacity: '1', display: 'block', position: 'absolute' });

        for (i = 1; i < slideCount; i++) {
            // Initializing elements - hiding other frames
            $("#" + divNameArray[i]).css({ opacity: '0', display: 'block', position: 'absolute' });
         }

        // Call first transition after initial delay
         setTimeout(function () { jAnimateDiv(divNameArray, transitionDelay, animationDelay, 0); }, animationDelay + transitionDelay);

         // Exit the function without animating
        return;
    }

    
    // Getting Array Indexes
    var nextSlideNumber = (currentSlideNumber + 1) % slideCount;
    var prevSlideNumber = ((currentSlideNumber) == 0) ? slideCount - 1 : currentSlideNumber - 1;

    // Hiding third slide down
    $("#" + divNameArray[prevSlideNumber]).css("opacity", 0);

    // Bringing new slide in from of old
    $("#" + divNameArray[currentSlideNumber]).css("zIndex", 4);
    $("#" + divNameArray[nextSlideNumber]).css("zIndex", 5);

    // Fading in the slide
    $("#" + divNameArray[nextSlideNumber]).animate({ opacity: 1.0 }, transitionDelay);

    // Calling next animation
    setTimeout(function(){jAnimateDiv(divNameArray, transitionDelay, animationDelay, nextSlideNumber);}, animationDelay + transitionDelay);
}